/*******************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Tasks.h
\brief      Tasks to be assigned to each execution thread of Task scheduler.
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       21/May/2008
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software ore advise supplied to the     */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connectionwith product, services or goods supplied     */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

#ifndef __TASKS
#define __TASKS

/*-- Includes ----------------------------------------------------------------*/
#include "Derivative.h"
#include "Pwm_Cfg.h"
/*-- Types Definitions -------------------------------------------------------*/
extern uint8_t  gu8Index;
/*-- Defines -----------------------------------------------------------------*/


/*-- Macros ------------------------------------------------------------------*/

/** List of tasks to be executed @ 100ms */
#define EXECUTE_100MS_TASKS()                               \
{                                                           \
   vfnSetDuty_Cycle(PWM_CHANNEL_0,DTY_AT_50P_WITH_150HZ);   \
}                                 

/** List of tasks to be executed @ 200ms */
#define EXECUTE_200MS_TASKS()                               \
{                                                           \
   vfnSetDuty_Cycle(PWM_CHANNEL_1,DTY_AT_70P_WITH_100HZ);   \
}

/** List of tasks to be executed @ 50ms */
#define EXECUTE_400MS_TASKS()                                                       \
{                                                                                   \
    vfnSetPeriodAndDuty(PWM_CHANNEL_2, SET_PERIOD_AT_100HZ ,DTY_AT_5P_WITH_100HZ);  \
}

/** List of tasks to be executed @ 800ms, first group */
#define EXECUTE_800MS_A_TASKS()  \
{                                \
    vfnSetPeriodAndDuty(PWM_CHANNEL_3, SET_PERIOD_AT_150HZ ,DTY_AT_20P_WITH_150HZ);  \
}
/* List of tasks to be executed @ 2ms, second group */
#define EXECUTE_800MS_B_TASKS()   \
{;}       


/*============================================================================*/
#endif /*__TASKS */
